use DocumentTools in 
#
# Application    = 2DOF_Stone_throwing
# Component.name = Slider_2DOF_Stone_throwing
# Component.type = Slider
#
# Omer Yagel,   07 - June - 2009
#

# Input
endTime := Do(%Slider0);

# Plots
P31 := plots[odeplot](Sol,[x(t),y(t)],t=0..endTime);
P32 := plot([ v_x * t, 
			  y0 + v_y * t - g/2 * t^2, 
			  t = 0 .. endTime],
			  color = blue
		   );
P4  := plots[odeplot](Sol,[[t,diff(x(t),t)],[t,diff(y(t),t)]],t=0..endTime);
P5  := plots[odeplot](Sol,[[t,x(t)],[t,y(t)]], t=0..endTime);


# Output
Do(%Plot3 = plots[display]([P31, P32]));
Do(%Plot4 = plots[display](P4));
Do(%Plot5 = plots[display](P5));


end use; 